<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


class CWidgetsWidgetModule extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "4",
		"name"	=> "Module Content",
		"module"	=> array(
			"name"	=> "",
			"id"	=> "",
			"type"	=> "",
		)
	);

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $base;

		if (!is_array($widget)) {
			return "";
		}

		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['core:widgets_acordeon']} as r,
				{$this->tables['core:widgets_acordeon_lang']} as l
			WHERE
				r.item_id = l.item_id AND 
				l.lang_id={$widget[lang_id]} AND
				r.widget_id={$widget[widget_id]}
			ORDER BY 
				item_order ASC			
			"

		);


		if (!is_array($items)) {
			return "";
		}

		global $base;

		foreach ($items as $key => $val) {


			$more = $this->plugins["modules"]->BuildLink(array(
				"type"	=> $val["item_link_type"],
				"link"	=> $val["item_link_link"],
				"module"=> $val["item_link_module"],
				"global"=> $val["item_link_global"],
			));

			if ($more) {
				$more = $this->tpl->blockReplace(
					"Link" ,
					array(
						"link"	=> $more,
						"size"	=> $val["item_link_size"],
						"target"=> $val["item_link_target"],
						"text"	=> $val["item_link_text"],
						"rel"		=> $val["item_link_rel"],
						"style"		=> $val["item_link_style"],

					)
				);
			} else {
				$more = "";
			}
			

			$items[$key]["link"] = $more;

			$items[$key]["icon"] = $this->tpl->blockReplace($val["item_icon"] ? "Icon" : "NoIcon" , $val);
			
		}
		
		return $this->tpl->blockReplace(
			"Main" , 
			array(
				"items"	=> $base->html->table(
					$this->tpl , 
					"",	
					$items
				)
			),
			$widget 
		);

	}
			

}


?>